//
//  OPItemURL.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 12-02-22.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import "OPDatabaseObjectWithOverview.h"

#import "OPItem.h"

@interface OPItemURL : OPDatabaseObjectWithOverview <OPDisplayOrderable>

+ (NSString *)extractSearchStringFromURLString:(NSString *)urlString;

@property (nonatomic, weak) OPItem * item;
@property (nonatomic, readonly) NSString * calculatedLabel;

// database properties
@property (nonatomic, copy) NSString * label;
@property (nonatomic, copy) NSString * URLString;
@property (nonatomic, copy) NSString * nakedHash;
@property (nonatomic, copy) NSString * derivedHash;
@property (nonatomic, assign) OPTimestamp hashVersion;
@property (nonatomic, assign) NSUInteger displayOrder;

+ (OPItemURL *)urlForItem:(OPItem *)item withDict:(NSDictionary *)dict;

- (BOOL)isEqualToItemURL:(OPItemURL *)itemURL;

- (NSString *)labelShownAtIndex:(NSInteger)index;
- (NSString *)URLStringWithoutScheme;
- (NSString *)URLStringWithoutSchemeAndQueryString;

- (void)replaceWith:(OPItemURL *)itemURL;

@end
